/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502;

import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandDefinition;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.commands.ADC;
import emulator.hardware.nmos6502.commands.ANC;
import emulator.hardware.nmos6502.commands.AND;
import emulator.hardware.nmos6502.commands.ASL;
import emulator.hardware.nmos6502.commands.ASO;
import emulator.hardware.nmos6502.commands.AXS;
import emulator.hardware.nmos6502.commands.BCC;
import emulator.hardware.nmos6502.commands.BCS;
import emulator.hardware.nmos6502.commands.BEQ;
import emulator.hardware.nmos6502.commands.BIT;
import emulator.hardware.nmos6502.commands.BMI;
import emulator.hardware.nmos6502.commands.BNE;
import emulator.hardware.nmos6502.commands.BPL;
import emulator.hardware.nmos6502.commands.BRK;
import emulator.hardware.nmos6502.commands.BVC;
import emulator.hardware.nmos6502.commands.BVS;
import emulator.hardware.nmos6502.commands.CLC;
import emulator.hardware.nmos6502.commands.CLD;
import emulator.hardware.nmos6502.commands.CLI;
import emulator.hardware.nmos6502.commands.CLV;
import emulator.hardware.nmos6502.commands.CMP;
import emulator.hardware.nmos6502.commands.CPX;
import emulator.hardware.nmos6502.commands.CPY;
import emulator.hardware.nmos6502.commands.DEC;
import emulator.hardware.nmos6502.commands.DEX;
import emulator.hardware.nmos6502.commands.DEY;
import emulator.hardware.nmos6502.commands.EOR;
import emulator.hardware.nmos6502.commands.INC;
import emulator.hardware.nmos6502.commands.INX;
import emulator.hardware.nmos6502.commands.INY;
import emulator.hardware.nmos6502.commands.IllegalOpcode;
import emulator.hardware.nmos6502.commands.JMP;
import emulator.hardware.nmos6502.commands.JSR;
import emulator.hardware.nmos6502.commands.LDA;
import emulator.hardware.nmos6502.commands.LDX;
import emulator.hardware.nmos6502.commands.LDY;
import emulator.hardware.nmos6502.commands.LSR;
import emulator.hardware.nmos6502.commands.NOP;
import emulator.hardware.nmos6502.commands.ORA;
import emulator.hardware.nmos6502.commands.PHA;
import emulator.hardware.nmos6502.commands.PHP;
import emulator.hardware.nmos6502.commands.PLA;
import emulator.hardware.nmos6502.commands.PLP;
import emulator.hardware.nmos6502.commands.ROL;
import emulator.hardware.nmos6502.commands.ROR;
import emulator.hardware.nmos6502.commands.RTI;
import emulator.hardware.nmos6502.commands.RTS;
import emulator.hardware.nmos6502.commands.SBC;
import emulator.hardware.nmos6502.commands.SEC;
import emulator.hardware.nmos6502.commands.SED;
import emulator.hardware.nmos6502.commands.SEI;
import emulator.hardware.nmos6502.commands.STA;
import emulator.hardware.nmos6502.commands.STX;
import emulator.hardware.nmos6502.commands.STY;
import emulator.hardware.nmos6502.commands.TAX;
import emulator.hardware.nmos6502.commands.TAY;
import emulator.hardware.nmos6502.commands.TSX;
import emulator.hardware.nmos6502.commands.TXA;
import emulator.hardware.nmos6502.commands.TXS;
import emulator.hardware.nmos6502.commands.TYA;
import emulator.hardware.nmos6502.operands.NoOperand;
import java.util.Vector;

public class CommandSet {
    private Vector<CommandDefinition> cset = new Vector(256);
    private CommandDefinition nil = new CommandDefinition(new IllegalOpcode(), new NoOperand());

    public CommandSet() {
        int i = 0;
        while (i < this.cset.capacity()) {
            this.cset.add(i, this.nil);
            ++i;
        }
        this.initCommands();
    }

    int getDefinitionCount() {
        int count = 0;
        int i = 0;
        while (i < this.cset.capacity()) {
            if (this.cset.get(i) != this.nil) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private void initCommands() {
        new ADC().register(this);
        new ANC().register(this);
        new AND().register(this);
        new ASL().register(this);
        new ASO().register(this);
        new AXS().register(this);
        new BCC().register(this);
        new BCS().register(this);
        new BEQ().register(this);
        new BIT().register(this);
        new BMI().register(this);
        new BNE().register(this);
        new BPL().register(this);
        new BRK().register(this);
        new BVC().register(this);
        new BVS().register(this);
        new CLC().register(this);
        new CLD().register(this);
        new CLI().register(this);
        new CLV().register(this);
        new CMP().register(this);
        new CPX().register(this);
        new CPY().register(this);
        new DEC().register(this);
        new DEX().register(this);
        new DEY().register(this);
        new EOR().register(this);
        new INC().register(this);
        new INX().register(this);
        new INY().register(this);
        new JMP().register(this);
        new JSR().register(this);
        new LDA().register(this);
        new LDX().register(this);
        new LDY().register(this);
        new LSR().register(this);
        new NOP().register(this);
        new ORA().register(this);
        new PHA().register(this);
        new PHP().register(this);
        new PLA().register(this);
        new PLP().register(this);
        new ROL().register(this);
        new ROR().register(this);
        new RTI().register(this);
        new RTS().register(this);
        new SBC().register(this);
        new SEC().register(this);
        new SED().register(this);
        new SEI().register(this);
        new STA().register(this);
        new STX().register(this);
        new STY().register(this);
        new TAX().register(this);
        new TAY().register(this);
        new TSX().register(this);
        new TXA().register(this);
        new TXS().register(this);
        new TYA().register(this);
    }

    public void defineCommand(int opcode, Command command, Operand operand) {
        this.cset.set(opcode, new CommandDefinition(command, operand));
    }

    public void defineCommand(int opcode, Command command, Operand operand, int cycles) {
        this.cset.set(opcode, new CommandDefinition(command, operand, cycles));
    }

    public CommandDefinition getCommand(HwByte opcode) {
        return this.cset.get((int)opcode.getNumber());
    }
}

